/********************************** (C) COPYRIGHT *******************************
* File Name          : USBH_HID.C
* Author             : MJX
* Version            : V1.00
* Date               : 2020/05/15
* Description        : USB HOSTHID豸س
*******************************************************************************/



/******************************************************************************/
/* ͷļ */
#include "MAIN.H"	 															/* ͷļ */

/******************************************************************************/
/*  */

/* USB HID豸SetProtocol */
UINT8C	SetupSetprotocol[ ] = { 0x21, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };       

/* USB HID豸SetIdle */
UINT8C	SetupSetidle[ ] = { 0x21, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

/* USB HID豸SetReport */
UINT8C	SetupSetReport[ ] = { 0x21, 0x09, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00 }; 

/* USB HID豸Ļȡ */
UINT8C	SetupGetHidDes[ ] = { 0x81, 0x06, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00 }; 

/*******************************************************************************
* Function Name  : HID_GetHidDesr
* Description    : USBHID豸ȡHID
* Input          : len: Ҫȡı
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 HID_GetHidDesr( UINT8 num, UINT8 *pbuf, UINT16 len )
{
	UINT8  s;
		
	USBH_CopySetupReqPkg( SetupGetHidDes );
	pSetupReq->wIndexL = num;
	pSetupReq->wLengthL = (UINT16)len;
	pSetupReq->wLengthH = (UINT16)( len >> 8 );	                                      
	s = USBH_CtrlTransfer( pbuf, &len );                         
	if( s != ERR_SUCCESS ) 
	{
		return( s );
	}
	return( ERR_SUCCESS );								          
}

/*******************************************************************************
* Function Name  : HID_SetReport
* Description    : USBHID豸SetReport
* Input          : speed: Ҫõֵ
*				   index: Ҫõ
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 HID_SetReport( UINT8 report[], UINT16 len, UINT8 index )
{
	UINT8  s;

	USBH_CopySetupReqPkg( SetupSetReport );
	if( len == 2 )
	{
		pSetupReq->wValueL = report[ 0 ];           
		pSetupReq->wIndexL = index; 		
		pSetupReq->wLengthL = 2; 
	}
	else
	{
		pSetupReq->wIndexL = index;		
	}
	s = USBH_CtrlTransfer( report, &len );
	return( s );
}

/*******************************************************************************
* Function Name  : HID_Sp_SetReport
* Description    : USBHID豸SetReport
* Input          : speed: Ҫõֵ
*				   index: Ҫõ
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 HID_Sp_SetReport( UINT8 *pbuf, UINT8 value, UINT16 len, UINT8 index )
{
	UINT8  s;

	USBH_CopySetupReqPkg( SetupSetReport ); 
    pSetupReq->wValueH = value;
	pSetupReq->wIndexL = index; 		
	pSetupReq->wLengthL = len; 
	s = USBH_CtrlTransfer( pbuf, &len );
	return( s );
}

/*******************************************************************************
* Function Name  : HID_SetIdleSpeed
* Description    : USBHID豸SetIdle
* Input          : speed: Ҫõֵ
*				   index: Ҫõ
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 HID_SetIdleSpeed( UINT8 speed, UINT8 index )   
{
	USBH_CopySetupReqPkg( SetupSetidle );		
	pSetupReq->wValueL = (UINT16)speed << 8;          
	pSetupReq->wIndexL = index; 	               
	return( USBH_CtrlTransfer( NULL, NULL ) ); 		
}

/********************************** end file ***********************************/

